<?php get_header(); ?>
	<?php if(is_page('6')): ?>
		<div id="main_visual">
			<picture>
				<source media="(max-width: 480px)" srcset="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024-480.jpg">
				<source media="(max-width: 768px)" srcset="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024.jpg">
				<img src="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024.jpg" alt="image">
			</picture>
		</div>
		<article>
			<section class="front_article">
				<div class="inner">
					<div id="front_news">
						<h3 class="title">ニュース</h2>
						<?php
							$args = array(
								'post_type' => 'news',
								'ignore_sticky_posts' => 1,
								'orderby' => 'date',
								'order' => 'DESC',
								'posts_per_page' => 6
							);
							$post_list = get_posts($args);
						?>
						<div class="news_list">
							<ul>
								<?php foreach ($post_list as $post) : setup_postdata ($post); ?>
									<li>
										<a href="<?php the_permalink(); ?>">
											<time datetime="<?php the_modified_time('c'); ?>"><?php the_time('Y.m.d'); ?></time>
											<span class="news_list_title"><?php the_title(); ?></span>
										</a>
									</li>
								<?php endforeach; wp_reset_query(); ?>
							</ul>
							<div class="more_read">
								<a href="<?php echo get_post_type_archive_link('news'); ?>">もっと読む</a>
							</div>
						</div>
					</div>
				</div>
			</section>
			<section id="front_info" class="front_article">
				<div class="calc_3 inner">
					<section class="calc_content">
						<a href="<?php echo get_permalink(9); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/business2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(9); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<span class="center">Business</span>
										<h2 class="center">事業案内</h2>
									</div>
									<p>
										百貨店や専門店に商品を供給するだけでなく、生活者目線の魅力的な売場を実現するために、フジイは営業面と物流面に加え、以下の業務によってサポートしてまいります。
									</p>
								</div>
							</div>
						</a>
					</section>
					<section class="calc_content">
						<a href="<?php echo get_permalink(11); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/products2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(11); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<span class="center">Products</span>
										<h2 class="center">商品情報</h2>
									</div>
									<p>
										永年に亘って築き上げてきた信用・実績・ノウハウにより、フジイは幅広い業務内容と圏内ネットワークを作り上げています。
									</p>
								</div>
							</div>
						</a>
					</section>
					<section class="calc_content">
						<a href="<?php echo get_permalink(13); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/about2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(13); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<span class="center">About us</span>
										<h2 class="center">会社案内</h2>
									</div>
									<p>
										大正12年の創業以来、株式会社フジイは日本全国へキッチンウェア、ハウスウェアをお届けしてまいりました。
									</p>
									<p>
										100年近くの歴史を持つオリジナルブランドの「月兎印」をはじめ、メーカとしてのスタンスも大切にしながら、ヨーロッパ、北米等のパートナーと共に新たなプロジェクトにも挑戦しております。
									</p>
								</div>
							</div>
						</a>
					</section>
				</div>
			</section>
		</article>
	<?php else: ?>
		<div id="main_visual">
			<picture>
				<source media="(max-width: 480px)" srcset="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024-480.jpg">
				<source media="(max-width: 768px)" srcset="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024.jpg">
				<img src="<?php bloginfo('template_url'); ?>/images/front/mainvisual2024.jpg" alt="image">
			</picture>
		</div>
		<article>
			<section id="front_info" class="front_article">
				<div class="calc_3 inner">
					<section class="calc_content">
						<a href="<?php echo get_permalink(105); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/business2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(105); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<h2 class="center">Business</h2>
									</div>
									<p>
										Our major business is composed of following items, trying to achieve an attractive, consumer-oriented market creation, in addition to our smooth distribution and operation of products to department and specialty stores.
									</p>
								</div>
							</div>
						</a>
					</section>
					<section class="calc_content">
						<a href="<?php echo get_permalink(155); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/products2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(155); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<h2 class="center">Products</h2>
									</div>
									<p>
										Fujii succeeded in extending operations and domestic networks with the reputation, the good performance, and the business know-how established for many years.
									</p>
								</div>
							</div>
						</a>
					</section>
					<section class="calc_content">
						<a href="<?php echo get_permalink(120); ?>">
							<figure>
								<img src="<?php bloginfo('template_url'); ?>/images/front/about2024.jpg">
							</figure>
						</a>
						<a href="<?php echo get_permalink(120); ?>">
							<div class="center bgc_gray">
								<div class="content">
									<div class="title">
										<h2 class="center">About us</h2>
									</div>
									<p>
										Established in 1923, Fujii Co.,Ltd started as a traditional manufacturer and wholesaler then expanded to be a trading company specialized in house wares, supplying mainly to department and specialty stores.
									</p>
								</div>
							</div>
						</a>
					</section>
				</div>
			</section>
		</article>
	<?php endif; ?>
<?php get_footer(); ?>